import { Router } from 'express';
import { aiController } from './controller';
import { authenticateUser, requireVendor } from '@/middlewares/auth';
import { checkFeature } from '@/middlewares/featureGate';
import { vendorService } from '@/modules/vendors/service';

const router = Router();

// Attach vendor to req for downstream use
async function attachVendor(req: any, res: any, next: any) {
  if (req.user) {
    const { data: vendor } = await vendorService.getVendorByUserId(req.user.id);
    // Optionally, fetch features for the vendor (for feature gate)
    // Here, you could call the subscriptionService.getAvailableFeatures
    // For now, assume vendor.features is an array of feature keys
    req.vendor = vendor || null;
  }
  next();
}

router.post('/generate-reminder', authenticateUser, requireVendor, attachVendor, checkFeature('ai_assistant'), aiController.generateReminder);
router.post('/generate-greeting', authenticateUser, requireVendor, attachVendor, checkFeature('ai_assistant'), aiController.generateGreeting);
router.post('/generate-shopping-assist', authenticateUser, requireVendor, attachVendor, checkFeature('ai_assistant'), aiController.generateShoppingAssist);
router.post('/generate-price-insight', authenticateUser, requireVendor, attachVendor, checkFeature('ai_assistant'), aiController.generatePriceInsight);
router.post('/general', authenticateUser, requireVendor, attachVendor, checkFeature('ai_assistant'), aiController.general);

export default router; 